/*
 * Decompiled with CFR 0.152.
 */
package matsubara.carcontroller;

public abstract class CarController {
    String m_sShiftPosition = "N";
    boolean m_bParkingBrake = false;
    double m_rOdoMeter = 0.0;
    double m_rTripMeter = 0.0;
    double m_rAcceleration = 0.0;
    double m_rFuel = 50.0;
    double m_rTotalUseFuel = 0.0;
    double m_rFuelEfficiency = 0.0;
    protected long m_nIgnitionTime;

    public String getShiftPosition() {
        return this.m_sShiftPosition;
    }

    public void setShiftPosition(String string) {
        this.m_sShiftPosition = string;
    }

    public boolean isParkingBrake() {
        return this.m_bParkingBrake;
    }

    public void setParkingBkare(boolean bl) {
        this.m_bParkingBrake = bl;
    }

    public double getFuel() {
        return this.m_rFuel;
    }

    public void setFuel(double d) {
        this.m_rFuel = d;
    }

    public final void drive(double d, int n, int n2) {
        double d2 = this.getSpeed();
        this.driveInternal(d, n, n2);
        double d3 = Math.abs(this.getSpeed());
        this.m_rOdoMeter += d3 * d / 3600000.0;
        this.m_rTripMeter += d3 * d / 3600000.0;
        this.m_rAcceleration = (this.getSpeed() - d2) * 1000.0 / 3600.0 / (d / 1000.0);
        double d4 = this.getUseFuel(d);
        if (d3 != 0.0) {
            this.m_rFuelEfficiency = d4 != 0.0 ? Math.abs(this.getSpeed()) / 3600.0 / 1000.0 * d / d4 : Double.POSITIVE_INFINITY;
            if (this.m_rFuelEfficiency > 99.9) {
                this.m_rFuelEfficiency = Double.POSITIVE_INFINITY;
            }
        } else {
            this.m_rFuelEfficiency = 0.0;
        }
        this.m_rTotalUseFuel += d4;
        this.m_rFuel -= d4;
        if (this.m_rFuel < 0.0) {
            this.m_rFuel = 0.0;
        }
    }

    protected abstract void driveInternal(double var1, int var3, int var4);

    public abstract double getSpeed();

    public abstract double getEngineRpm();

    protected double getUseFuel(double d) {
        return 0.0;
    }

    public int getOdoMeter() {
        return (int)this.m_rOdoMeter;
    }

    public double getTripMeter() {
        return this.m_rTripMeter;
    }

    public void resetTripMeter() {
        this.m_rTripMeter = 0.0;
    }

    public double getTotalUseFuel() {
        return this.m_rTotalUseFuel;
    }

    public void resetTotalUseFuel() {
        this.m_rTotalUseFuel = 0.0;
    }

    public double getAcceleration() {
        return this.m_rAcceleration;
    }

    public double getFuelEfficiency() {
        return this.m_rFuelEfficiency;
    }

    public void ignition() {
        this.m_nIgnitionTime = System.currentTimeMillis();
    }

    public void unIgnition() {
        this.m_nIgnitionTime = 0L;
    }

    public boolean isIgnition() {
        return this.m_nIgnitionTime != 0L;
    }

    public long getIgnitionTime() {
        return this.m_nIgnitionTime;
    }
}

