/*
 * Decompiled with CFR 0.152.
 */
package matsubara.thssimulator;

import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import matsubara.carcontroller.ThsController;
import matsubara.gear.PlanetaryGear;
import matsubara.graphics.ProgressLine;
import matsubara.thssimulator.ThsDrawThread;
import matsubara.uiext.Slider;
import matsubara.uiext.event.ChangeEvent;
import matsubara.uiext.event.ChangeListener;

public class ThsApplet
extends Applet {
    public final String mc_sApplicationName = "Prius driving simulator";
    public final String mc_sVersion = "version 1.4.0";
    public final String mc_sCopyright = "copyright(c) 2002 m.matsubara";
    private ResourceBundle m_res = ResourceBundle.getBundle("matsubara.thssimulator.ThsAppletRes");
    private ThsDrawThread m_threadDraw;
    private ThsController m_thsController = null;
    private Image m_imgPGear = null;
    private Image[] m_imgPrius = new Image[2];
    private Image[] m_imgKame = new Image[2];
    private int m_nImgPriusNo = 0;
    private Image m_imgMotor;
    private Image m_imgKaisei;
    private Image m_imgGasoline;
    private Image m_imgMeter;
    private Image m_imgMeterKame;
    private Image m_imgEnergyMonitor;
    private Image m_imgPriusBrake;
    final int m_nMeterBaseX = 200;
    final int m_nMeterBaseY = 55;
    final int m_nEmOffsetX = 447;
    final int m_nEmOffsetY = 0;
    private ProgressLine m_lineBI = new ProgressLine(568, 38, 559, 64, Color.red, 6);
    private ProgressLine m_lineIM = new ProgressLine(559, 64, 549, 94, Color.red, 6);
    private ProgressLine m_lineMF = new ProgressLine(549, 94, 530, 88, Color.red, 6);
    private ProgressLine m_lineIG = new ProgressLine(559, 64, 532, 57, Color.red, 6);
    private ProgressLine m_lineGP = new ProgressLine(532, 57, 519, 84, Color.red, 6);
    private ProgressLine m_lineEP = new ProgressLine(497, 77, 519, 84, Color.red, 6);
    private ProgressLine m_linePF = new ProgressLine(519, 84, 530, 88, Color.red, 6);
    private ProgressLine m_lineFT = new ProgressLine(530, 88, 517, 116, Color.red, 6);
    private Image m_imgRoad = null;
    private double m_rRoadPosition = 0.0;
    private String m_sMessage1 = "TOYOTA Hybrid System Simulation - Type HK-NHW10-AEEEB (Japanese specifications)";
    private String m_sMessage2 = "copyright (c) 2002 m.matsubara";
    private long m_nSystemStartTime;
    boolean isStandalone = false;
    Label lbPowerSplitDevice = new Label();
    Label label2 = new Label();
    Label lbRingGearSpeed = new Label();
    Label label4 = new Label();
    Label lbPlaCarrierSpeed = new Label();
    Label label6 = new Label();
    Label lbSunGearSpeed = new Label();
    Choice cmbRange = new Choice();
    Panel panel1 = new Panel();
    Checkbox ckDriveMode = new Checkbox();
    Label label8 = new Label();
    Label label9 = new Label();
    Slider sliRingGear = new Slider();
    Slider sliPlaCarrier = new Slider();
    Slider sliSunGear = new Slider();
    Slider sliBrake = new Slider();
    Slider sliAccel = new Slider();
    private static Image m_imgOffScreen = null;
    private boolean m_bDrawingThsObjects = false;

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public ThsApplet() {
        try {
            this.m_thsController = new ThsController(80, 80, 60);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_nSystemStartTime = System.currentTimeMillis();
    }

    public void init() {
        String string = this.getParameter("Language", null);
        String string2 = this.getParameter("Country", null);
        if (string != null && string2 != null) {
            this.m_res = ResourceBundle.getBundle("matsubara.thssimulator.ThsAppletRes", new Locale(string, string2));
            System.out.println("Language : " + string);
            System.out.println("Country : " + string2);
        } else if (string != null) {
            this.m_res = ResourceBundle.getBundle("matsubara.thssimulator.ThsAppletRes", new Locale(string, ""));
            System.out.println("Language : " + string);
        }
        System.out.println("Resource classes : " + this.m_res.getClass().getName());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.lbPowerSplitDevice.setAlignment(1);
        this.lbPowerSplitDevice.setFont(new Font("Dialog", 0, 12));
        this.lbPowerSplitDevice.setForeground(new Color(182, 99, 0));
        this.lbPowerSplitDevice.setText(this.m_res.getString("sPowerSplitDevice_PlanetaryGear"));
        this.lbPowerSplitDevice.setBounds(new Rectangle(0, 7, 200, 17));
        this.setBackground(Color.white);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ThsApplet.this.this_mouseMoved(mouseEvent);
            }
        });
        this.setLayout(null);
        this.label2.setAlignment(1);
        this.label2.setFont(new Font("Dialog", 0, 12));
        this.label2.setForeground(new Color(0, 186, 0));
        this.label2.setText(this.m_res.getString("sMotor"));
        this.label2.setBounds(new Rectangle(209, 6, 56, 17));
        this.lbRingGearSpeed.setAlignment(2);
        this.lbRingGearSpeed.setForeground(new Color(0, 186, 0));
        this.lbRingGearSpeed.setText("0 rpm");
        this.lbRingGearSpeed.setBounds(new Rectangle(204, 21, 67, 17));
        this.label4.setAlignment(1);
        this.label4.setFont(new Font("Dialog", 0, 12));
        this.label4.setForeground(Color.red);
        this.label4.setText(this.m_res.getString("sEngine"));
        this.label4.setBounds(new Rectangle(276, 6, 59, 17));
        this.lbPlaCarrierSpeed.setAlignment(2);
        this.lbPlaCarrierSpeed.setForeground(Color.red);
        this.lbPlaCarrierSpeed.setText("0 rpm");
        this.lbPlaCarrierSpeed.setBounds(new Rectangle(272, 21, 67, 17));
        this.label6.setAlignment(1);
        this.label6.setFont(new Font("Dialog", 0, 12));
        this.label6.setForeground(Color.blue);
        this.label6.setText(this.m_res.getString("sGenerator"));
        this.label6.setBounds(new Rectangle(387, 6, 63, 17));
        this.lbSunGearSpeed.setAlignment(2);
        this.lbSunGearSpeed.setForeground(Color.blue);
        this.lbSunGearSpeed.setText("0 rpm");
        this.lbSunGearSpeed.setBounds(new Rectangle(385, 21, 67, 17));
        this.cmbRange.setBackground(new Color(204, 204, 205));
        this.cmbRange.setEnabled(false);
        this.cmbRange.setBounds(new Rectangle(10, 27, 104, 24));
        this.cmbRange.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ThsApplet.this.cmbRange_itemStateChanged(itemEvent);
            }
        });
        this.panel1.setBackground(new Color(204, 204, 205));
        this.panel1.setBounds(new Rectangle(464, 10, 124, 177));
        this.panel1.setLayout(null);
        this.ckDriveMode.setBackground(new Color(204, 204, 205));
        this.ckDriveMode.setFont(new Font("Dialog", 0, 12));
        this.ckDriveMode.setLabel(this.m_res.getString("sDriveMode"));
        this.ckDriveMode.setBounds(new Rectangle(19, 1, 88, 25));
        this.ckDriveMode.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ThsApplet.this.ckDriveMode_mouseMoved(mouseEvent);
            }
        });
        this.ckDriveMode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ThsApplet.this.ckDriveMode_itemStateChanged(itemEvent);
            }
        });
        this.label8.setAlignment(1);
        this.label8.setFont(new Font("Dialog", 0, 12));
        this.label8.setText(this.m_res.getString("sBrake"));
        this.label8.setBounds(new Rectangle(7, 156, 51, 17));
        this.label9.setAlignment(1);
        this.label9.setFont(new Font("Dialog", 0, 12));
        this.label9.setText(this.m_res.getString("sAccel"));
        this.label9.setBounds(new Rectangle(68, 156, 52, 17));
        this.sliRingGear.setBounds(new Rectangle(202, 43, 70, 136));
        this.sliRingGear.setMaximum(6000);
        this.sliRingGear.setMinimum(-2000);
        this.sliRingGear.setMajorTickSpacing(2000);
        this.sliRingGear.setMinorTickSpacing(1000);
        this.sliRingGear.setPrintLabel(true);
        this.sliRingGear.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThsApplet.this.sliRingGear_stateChanged(changeEvent);
            }
        });
        this.sliRingGear.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ThsApplet.this.sliRingGear_mouseMoved(mouseEvent);
            }
        });
        this.sliPlaCarrier.setPrintLabel(true);
        this.sliPlaCarrier.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThsApplet.this.sliPlaCarrier_stateChanged(changeEvent);
            }
        });
        this.sliPlaCarrier.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ThsApplet.this.sliPlaCarrier_mouseMoved(mouseEvent);
            }
        });
        this.sliPlaCarrier.setMajorTickSpacing(2000);
        this.sliPlaCarrier.setMaximum(4000);
        this.sliPlaCarrier.setBounds(new Rectangle(272, 73, 67, 79));
        this.sliPlaCarrier.setMinorTickSpacing(1000);
        this.sliSunGear.setPrintLabel(true);
        this.sliSunGear.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ThsApplet.this.sliSunGear_mouseMoved(mouseEvent);
            }
        });
        this.sliSunGear.setMajorTickSpacing(2000);
        this.sliSunGear.setMinimum(-4000);
        this.sliSunGear.setMaximum(6000);
        this.sliSunGear.setEnabled(false);
        this.sliSunGear.setBounds(new Rectangle(384, 40, 69, 172));
        this.sliSunGear.setMinorTickSpacing(1000);
        this.sliBrake.setBounds(new Rectangle(21, 55, 37, 96));
        this.sliBrake.setEnabled(false);
        this.sliBrake.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThsApplet.this.sliBrake_stateChanged(changeEvent);
            }
        });
        this.sliAccel.setBounds(new Rectangle(79, 55, 37, 96));
        this.sliAccel.setEnabled(false);
        this.sliAccel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThsApplet.this.sliAccel_stateChanged(changeEvent);
            }
        });
        this.add((Component)this.label2, null);
        this.add((Component)this.lbRingGearSpeed, null);
        this.add((Component)this.label6, null);
        this.add((Component)this.lbSunGearSpeed, null);
        this.panel1.add((Component)this.label8, null);
        this.panel1.add((Component)this.label9, null);
        this.panel1.add((Component)this.ckDriveMode, null);
        this.panel1.add((Component)this.cmbRange, null);
        this.panel1.add((Component)this.sliAccel, null);
        this.panel1.add((Component)this.sliBrake, null);
        this.add((Component)this.lbPlaCarrierSpeed, null);
        this.add((Component)this.label4, null);
        this.add((Component)this.panel1, null);
        this.add((Component)this.sliSunGear, null);
        this.add((Component)this.lbPowerSplitDevice, null);
        this.add((Component)this.sliRingGear, null);
        this.add((Component)this.sliPlaCarrier, null);
    }

    public void start() {
        System.out.println("Welcome to Prius");
        System.out.println("Prius driving simulator - ignition !!");
        this.m_imgPGear = this.createImage(160, 160);
        this.m_imgRoad = this.createImage(600, 180);
        this.m_imgPrius[0] = this.loadImage("/matsubara/thssimulator/image/prius1.gif");
        this.m_imgPrius[1] = this.loadImage("/matsubara/thssimulator/image/prius2.gif");
        this.m_imgKame[0] = this.loadImage("/matsubara/thssimulator/image/kame1.gif");
        this.m_imgKame[1] = this.loadImage("/matsubara/thssimulator/image/kame2.gif");
        this.m_imgMotor = this.loadImage("/matsubara/thssimulator/image/motor.gif");
        this.m_imgKaisei = this.loadImage("/matsubara/thssimulator/image/kaisei.gif");
        this.m_imgGasoline = this.loadImage("/matsubara/thssimulator/image/gasoline.gif");
        this.m_imgMeter = this.loadImage("/matsubara/thssimulator/image/meter.gif");
        this.m_imgMeterKame = this.loadImage("/matsubara/thssimulator/image/meterKame.gif");
        this.m_imgEnergyMonitor = this.loadImage("/matsubara/thssimulator/image/energyMonitor.gif");
        this.m_imgPriusBrake = this.loadImage("/matsubara/thssimulator/image/priusBrake.gif");
        this.cmbRange.addItem("P Range");
        this.cmbRange.addItem("R Range");
        this.cmbRange.addItem("N Range");
        this.cmbRange.addItem("D Range");
        this.cmbRange.addItem("B Range");
        this.cmbRange.select(0);
        this.m_thsController.setShiftPosition("P");
        this.m_threadDraw = new ThsDrawThread(this);
        this.m_threadDraw.start();
    }

    public void stop() {
        this.m_threadDraw.stopRequest();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Prius driving simulator version 1.4.0 copyright(c) 2002 m.matsubara");
        System.out.println("good bye :-)");
    }

    public void destroy() {
    }

    public String getAppletInfo() {
        return "Prius driving simulator version 1.4.0 copyright(c) 2002 m.matsubara";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Language", "String", ""}, {"Country", "String", ""}};
        return stringArray;
    }

    public static void main(String[] stringArray) {
        ThsApplet thsApplet = new ThsApplet();
        thsApplet.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent windowEvent) {
                super.processWindowEvent(windowEvent);
                if (windowEvent.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String string) {
                super.setTitle(string);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Prius driving simulator");
        frame.add((Component)thsApplet, "Center");
        thsApplet.init();
        ((Component)frame).setSize(610, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        ((Component)frame).setVisible(true);
        thsApplet.start();
    }

    public Image createImage(int n, int n2) {
        Image image = super.createImage(n, n2);
        if (image == null) {
            try {
                Class<?> clazz = Class.forName("java.awt.image.BufferedImage");
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                image = (Image)constructor.newInstance(new Integer(n), new Integer(n2), new Integer(clazz.getField("TYPE_INT_RGB").getInt(null)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return image;
    }

    Image loadImage(String string) {
        Image image;
        Class<?> clazz = this.getClass();
        try {
            image = this.createImage((ImageProducer)clazz.getResource(string).getContent());
        }
        catch (Exception exception) {
            try {
                image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(string));
            }
            catch (Exception exception2) {
                System.out.println("image file load error : " + exception.getMessage());
                System.out.println("  (" + string + ")");
                image = this.createImage(100, 20);
                Graphics graphics = image.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, 100, 20);
                graphics.setColor(Color.red);
                graphics.drawString("image load error.", 5, 15);
            }
        }
        return image;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            this.drawThsObjects(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics graphics) {
        if (m_imgOffScreen == null) {
            m_imgOffScreen = this.createImage(600, 380);
        }
        Image image = m_imgOffScreen;
        synchronized (image) {
            Graphics graphics2 = m_imgOffScreen.getGraphics();
            graphics2.clearRect(0, 0, 600, 380);
            this.print(graphics2);
            graphics.drawImage(m_imgOffScreen, 0, 0, null);
        }
    }

    public double getSpeed() {
        return this.m_thsController.getSpeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawThsObjects(Graphics graphics) {
        ThsApplet thsApplet = this;
        synchronized (thsApplet) {
            if (!this.m_bDrawingThsObjects) {
                this.m_bDrawingThsObjects = true;
                try {
                    this.drawThsObjectsInternal(graphics);
                    Object var4_3 = null;
                    this.m_bDrawingThsObjects = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.m_bDrawingThsObjects = false;
                    throw throwable;
                }
            }
        }
    }

    public void drawThsObjectsInternal(Graphics graphics) {
        PlanetaryGear planetaryGear = this.m_thsController.getPlanetaryGear();
        double d = this.getSpeed();
        if (this.m_thsController.isGasoline()) {
            planetaryGear.getPlanetaryCarrier().setColor1(Color.white);
            planetaryGear.getPlanetaryCarrier().setColor2(Color.red);
        } else {
            planetaryGear.getPlanetaryCarrier().setColor1(new Color(224, 224, 224));
            planetaryGear.getPlanetaryCarrier().setColor2(new Color(224, 0, 0));
        }
        if (planetaryGear.getSunGearSpeed() > 0.0) {
            planetaryGear.getSunGear().setColor1(Color.white);
            planetaryGear.getSunGear().setColor2(Color.blue);
        } else {
            planetaryGear.getSunGear().setColor1(new Color(224, 224, 224));
            planetaryGear.getSunGear().setColor2(new Color(0, 0, 210));
        }
        Graphics graphics2 = this.m_imgPGear.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, this.m_imgPGear.getWidth(null), this.m_imgPGear.getHeight(null));
        planetaryGear.draw(graphics2);
        graphics2 = this.m_imgRoad.getGraphics();
        graphics2.setColor(new Color(160, 160, 160));
        graphics2.fillRect(0, 0, 445, 100);
        graphics2.setColor(Color.white);
        graphics2.fillRect(445, 0, 155, 100);
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 100, 600, 120);
        int n = -65 - (int)this.m_rRoadPosition;
        while (n < 700 + (int)this.m_rRoadPosition) {
            graphics2.fillRect(n, 48, 65, 4);
            n += 100;
        }
        if (this.m_thsController.isPowerSaveMode() && (System.currentTimeMillis() - this.m_nSystemStartTime) % 2600L < 1300L && this.ckDriveMode.getState()) {
            graphics2.drawImage(this.m_imgKame[this.m_nImgPriusNo], 60 + (int)(this.getSpeed() / 4.0), 1, null);
        } else {
            graphics2.drawImage(this.m_imgPrius[this.m_nImgPriusNo], 60 + (int)(this.getSpeed() / 4.0), 1, null);
            if (this.sliBrake.getValue() >= 3) {
                graphics2.drawImage(this.m_imgPriusBrake, 60 + (int)(this.getSpeed() / 4.0), 1, null);
            }
            if (this.m_thsController.getShiftPosition().equals("R") || !this.ckDriveMode.getState() && d < 0.0) {
                graphics2.setColor(Color.white);
                graphics2.fillRect(60 + (int)(this.getSpeed() / 4.0) + 2, 23, 1, 1);
            }
        }
        this.drawMeter(graphics2);
        this.drawEnergyMonitor(graphics2);
        if (this.ckDriveMode.getState()) {
            if (this.m_thsController.isMotor()) {
                graphics2.drawImage(this.m_imgMotor, 50, 55, null);
            }
            if (this.m_thsController.isKaisei()) {
                graphics2.drawImage(this.m_imgKaisei, 50, 55, null);
            }
            if (this.m_thsController.isGasoline()) {
                graphics2.drawImage(this.m_imgGasoline, 90, 55, null);
            }
            String string = this.m_res.getString("sMileageUnit");
            double d2 = Double.valueOf(this.m_res.getString("nMileageRate"));
            int n2 = Integer.valueOf(this.m_res.getString("nMileageCalcMode"));
            int n3 = Integer.valueOf(this.m_res.getString("nMaxMileage"));
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            double d3 = this.m_thsController.getFuelEfficiency();
            d3 = n2 == 0 ? (d3 /= d2) : (d3 != 0.0 ? d2 / d3 : Double.POSITIVE_INFINITY);
            String string2 = this.m_res.getString("sMomentMileage") + " : " + decimalFormat.format(d3) + " " + string;
            Font font = new Font("dialog", 0, 12);
            Color color = new Color(114, 114, 153);
            graphics2.setFont(font);
            graphics2.setColor(color);
            graphics2.fillRoundRect(310, 2, (int)(130.0 * Math.min(d3, (double)n3) / (double)n3), 18, 3, 3);
            graphics2.setColor(Color.white);
            graphics2.drawRoundRect(310, 2, 130, 18, 2, 2);
            graphics2.drawString(string2, 315, 16);
            d3 = this.m_thsController.getTotalUseFuel() != 0.0 ? Math.abs(this.m_thsController.getTripMeter()) / this.m_thsController.getTotalUseFuel() : (this.m_thsController.getTripMeter() == 0.0 ? 0.0 : Double.POSITIVE_INFINITY);
            d3 = n2 == 0 ? (d3 /= d2) : (d3 != 0.0 ? d2 / d3 : Double.POSITIVE_INFINITY);
            string2 = this.m_res.getString("sTotalMileage") + " : " + decimalFormat.format(d3) + " " + string;
            graphics2.setColor(color);
            graphics2.fillRoundRect(310, 22, (int)(130.0 * Math.min(d3, (double)n3) / (double)n3), 18, 3, 3);
            graphics2.setColor(Color.white);
            graphics2.drawRoundRect(310, 22, 130, 18, 2, 2);
            graphics2.drawString(string2, 315, 36);
        }
        graphics2.setFont(new Font(this.m_res.getString("sMsgFontName"), 0, Integer.valueOf(this.m_res.getString("nMsgFontSize"))));
        graphics2.setColor(Color.black);
        graphics2.drawString(this.m_sMessage1, 5, 115);
        graphics2.drawString(this.m_sMessage2, 5, 135);
        graphics.drawImage(this.m_imgPGear, 20, 20, null);
        graphics.drawImage(this.m_imgRoad, 0, 215, null);
    }

    public void drawMeter(Graphics graphics) {
        Color color = new Color(64, 255, 255);
        Color color2 = new Color(255, 100, 0);
        Font font = new Font("Monospaced", 0, 26);
        Font font2 = new Font("Dialog", 0, 10);
        Font font3 = new Font("Dialog", 0, 9);
        double d = this.getSpeed();
        graphics.drawImage(this.m_imgMeter, 200, 55, null);
        if (!this.m_thsController.isIgnition()) {
            graphics.setColor(Color.black);
            graphics.fillRect(247, 56, 62, 10);
        } else if (!this.m_thsController.isReady() && (System.currentTimeMillis() - this.m_thsController.getIgnitionTime()) % 400L >= 200L) {
            graphics.setColor(Color.black);
            graphics.fillRect(247, 56, 62, 10);
        }
        int n = this.ckDriveMode.getState() ? this.cmbRange.getSelectedIndex() : (d > 0.0 ? 3 : (d < 0.0 ? 1 : 0));
        if (n == 1) {
            graphics.setColor(color2);
        } else {
            graphics.setColor(color);
        }
        graphics.drawRoundRect(246 + 13 * n, 66, 10, 12, 2, 2);
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        String string = String.valueOf((int)Math.abs(d / Double.valueOf(this.m_res.getString("nSpeedRate"))));
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(string, 356 - graphics.getFontMetrics().stringWidth(string), 90);
        graphics.setFont(font2);
        graphics.drawString(this.m_res.getString("sSpeedUnit"), 357, 90);
        StringBuffer stringBuffer = decimalFormat.format(this.m_thsController.getTripMeter() / Double.valueOf(this.m_res.getString("nDistanceRate")), new StringBuffer(10), new FieldPosition(4));
        graphics.setFont(font3);
        graphics.setColor(color);
        stringBuffer.append(this.m_res.getString("sDistanceUnit"));
        int n2 = graphics.getFontMetrics().stringWidth(stringBuffer.toString());
        graphics.drawString(stringBuffer.toString(), 310 - n2, 90);
        int n3 = (int)((50.0 - this.m_thsController.getFuel()) / 4.777777777777778);
        if (n3 != 0) {
            if (n3 > 10) {
                n3 = 10;
            }
            graphics.setColor(Color.black);
            graphics.fillRect(228, 61, 7, n3 * 3);
            if (n3 >= 9) {
                graphics.setColor(color2);
                graphics.fillRect(235, 88, 4, 3);
            }
        }
        if (this.ckDriveMode.getState()) {
            if (this.m_thsController.isPowerSaveMode()) {
                graphics.drawImage(this.m_imgMeterKame, 208, 60, null);
            }
            if (this.m_thsController.getFuel() <= 0.0) {
                graphics.setColor(color2);
                graphics.drawLine(367, 70, 372, 80);
                graphics.drawLine(367, 70, 362, 80);
                graphics.drawLine(372, 80, 362, 80);
                graphics.drawLine(367, 73, 367, 76);
                graphics.drawLine(367, 78, 367, 78);
            }
        }
    }

    public void drawEnergyMonitor(Graphics graphics) {
        graphics.drawImage(this.m_imgEnergyMonitor, 447, 0, null);
        this.drawAxis(graphics, 559, 98, this.m_thsController.getRingGear().getAngle(), this.m_thsController.getRingGear().getColor2(), 7);
        this.drawAxis(graphics, 487, 80, this.m_thsController.getPlanetaryCarrier().getAngle(), this.m_thsController.getPlanetaryCarrier().getColor2(), 7);
        this.drawAxis(graphics, 517, 62, this.m_thsController.getSunGear().getAngle(), this.m_thsController.getSunGear().getColor2(), 7);
        graphics.setFont(new Font("Dialog", 0, 10));
        graphics.setColor(Color.red);
        graphics.drawString(this.m_res.getString("sEngine"), 455, 65);
        graphics.setColor(Color.blue);
        graphics.drawString(this.m_res.getString("sGenerator"), 497, 50);
        graphics.drawString(this.m_res.getString("sBattery"), 522, 30);
        graphics.setColor(Color.black);
        graphics.drawString(this.m_res.getString("sInverter"), 537, 72);
        graphics.setColor(this.m_thsController.getRingGear().getColor2());
        graphics.drawString(this.m_res.getString("sMotor"), 537, 115);
        graphics.setColor(this.lbPowerSplitDevice.getForeground());
        graphics.drawString(this.m_res.getString("sPowerSplitDevice"), 455, 103);
        if (this.ckDriveMode.getState()) {
            Object object;
            double d = this.m_thsController.getEngineRpm();
            if (d > 0.0 && d < 950.0 && this.m_thsController.getAcceleration() != 0.0) {
                graphics.setFont(new Font("Dialog", 1, 11));
                object = this.m_thsController.getAcceleration() >= 0.0 ? "start" : "stop";
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.setColor(new Color(170, 68, 0));
                graphics.fillRect(475, 73, fontMetrics.stringWidth((String)object) + 4, fontMetrics.getHeight());
                graphics.setColor(new Color(255, 102, 0));
                graphics.drawRect(475, 73, fontMetrics.stringWidth((String)object) + 4, fontMetrics.getHeight());
                graphics.drawString((String)object, 477, 73 + fontMetrics.getAscent());
            }
            this.m_lineBI.setReverse(false);
            this.m_lineIM.setReverse(false);
            this.m_lineMF.setReverse(false);
            this.m_lineIG.setReverse(false);
            this.m_lineGP.setReverse(false);
            this.m_lineEP.setReverse(false);
            this.m_linePF.setReverse(false);
            this.m_lineFT.setReverse(false);
            this.m_lineBI.setColor(Color.red);
            this.m_lineIM.setColor(Color.red);
            this.m_lineMF.setColor(Color.red);
            this.m_lineFT.setColor(Color.red);
            switch (this.m_thsController.getThsMode()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.m_lineGP.setReverse(true);
                    this.m_lineIG.setReverse(true);
                    this.m_lineBI.setReverse(true);
                    this.m_lineBI.setColor(Color.green);
                    this.m_lineEP.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineBI.draw(graphics);
                    break;
                }
                case 2: {
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    break;
                }
                case 3: {
                    this.m_lineGP.setReverse(true);
                    this.m_lineIG.setReverse(true);
                    this.m_lineBI.setReverse(true);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineBI.draw(graphics);
                    break;
                }
                case 4: {
                    this.m_lineIM.setReverse(true);
                    this.m_lineMF.setReverse(true);
                    this.m_lineBI.setReverse(true);
                    this.m_lineBI.setColor(Color.green);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    break;
                }
                case 5: {
                    this.m_lineGP.setReverse(true);
                    this.m_lineIG.setReverse(true);
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    break;
                }
                case 6: {
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    break;
                }
                case 8: {
                    this.m_lineIG.setReverse(true);
                    this.m_lineGP.setReverse(true);
                    this.m_lineEP.setReverse(true);
                    this.m_linePF.setReverse(true);
                    this.m_lineIG.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                }
                case 7: {
                    this.m_lineBI.setReverse(true);
                    this.m_lineIM.setReverse(true);
                    this.m_lineMF.setReverse(true);
                    this.m_lineFT.setReverse(true);
                    this.m_lineBI.setColor(Color.green);
                    this.m_lineIM.setColor(Color.green);
                    this.m_lineMF.setColor(Color.green);
                    this.m_lineFT.setColor(Color.green);
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                    break;
                }
                case 9: {
                    this.m_lineBI.setReverse(true);
                    this.m_linePF.setReverse(true);
                    this.m_lineIG.setReverse(true);
                    this.m_lineGP.setReverse(true);
                    this.m_lineBI.setColor(Color.green);
                    this.m_lineBI.draw(graphics);
                    this.m_lineIM.draw(graphics);
                    this.m_lineMF.draw(graphics);
                    this.m_lineIG.draw(graphics);
                    this.m_lineGP.draw(graphics);
                    this.m_lineEP.draw(graphics);
                    this.m_linePF.draw(graphics);
                    this.m_lineFT.draw(graphics);
                }
            }
            object = new DecimalFormat("0.0");
            double d2 = this.m_thsController.getBatterySOC();
            String string = "batt " + ((NumberFormat)object).format(d2) + "%";
            int n = (int)(d2 / 100.0 * 40.0);
            if (this.m_thsController.isPowerSaveMode()) {
                graphics.setColor(Color.red);
            } else if (this.m_thsController.getBatterySOC() < 45.0) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.green);
            }
            graphics.fillRect(455, 10, n, 10);
            graphics.setColor(Color.white);
            graphics.drawRect(455, 10, 40, 10);
            graphics.drawRect(495, 13, 2, 4);
            graphics.setFont(new Font("Dialog", 0, 9));
            graphics.drawString(string, 455, 33);
        }
    }

    void moveThs(long l) {
        PlanetaryGear planetaryGear = this.m_thsController.getPlanetaryGear();
        double d = this.getSpeed();
        if (this.ckDriveMode.getState()) {
            this.m_thsController.drive(l, this.sliAccel.getValue(), this.sliBrake.getValue());
            this.sliRingGear.setValue((int)planetaryGear.getRingGearSpeed());
            this.sliPlaCarrier.setValue((int)planetaryGear.getPlaCarrierSpeed());
        } else {
            planetaryGear.move((double)l / 100.0);
        }
        this.m_rRoadPosition += d / 4.0;
        this.m_rRoadPosition %= 100.0;
        if ((int)d != 0) {
            ++this.m_nImgPriusNo;
            this.m_nImgPriusNo %= 2;
        }
        if (this.ckDriveMode.getState()) {
            int n = (int)(l / 10L);
            this.m_lineBI.movePosition(n);
            this.m_lineIM.movePosition(n);
            this.m_lineMF.movePosition(n);
            this.m_lineIG.movePosition(n);
            this.m_lineGP.movePosition(n);
            this.m_lineEP.movePosition(n);
            this.m_linePF.movePosition(n);
            this.m_lineFT.movePosition(n);
        }
        if (this.ckDriveMode.getState()) {
            if (this.m_thsController.getFuel() <= 0.0) {
                this.m_sMessage1 = this.m_res.getString("sNoGas1");
                this.m_sMessage2 = this.m_thsController.getBatterySOC() < 40.0 ? this.m_res.getString("sNoGas2") : this.m_res.getString("sNoGas2MotorRun");
            } else {
                switch (this.m_thsController.getThsMode()) {
                    case 0: {
                        this.m_sMessage1 = this.m_res.getString("sRunStop1");
                        this.m_sMessage2 = this.m_res.getString("sRunStop2");
                        break;
                    }
                    case 1: {
                        this.m_sMessage1 = this.m_res.getString("sRunStopAndEngine1");
                        this.m_sMessage2 = this.m_res.getString("sRunStopAndEngine2");
                        break;
                    }
                    case 2: {
                        this.m_sMessage1 = this.m_res.getString("sRunStart1");
                        this.m_sMessage2 = this.m_res.getString("sRunStart2");
                        break;
                    }
                    case 3: {
                        this.m_sMessage1 = this.m_res.getString("sRunNormal1");
                        this.m_sMessage2 = this.m_res.getString("sRunNormal2");
                        break;
                    }
                    case 4: {
                        this.m_sMessage1 = this.m_res.getString("sRunNormalOD1");
                        this.m_sMessage2 = this.m_res.getString("sRunNormalOD2");
                        break;
                    }
                    case 5: {
                        this.m_sMessage1 = this.m_res.getString("sRunFullAccel1");
                        this.m_sMessage2 = this.m_res.getString("sRunFullAccel2");
                        break;
                    }
                    case 6: {
                        this.m_sMessage1 = this.m_res.getString("sRunFullAccel1");
                        this.m_sMessage2 = this.m_res.getString("sRunFullAccel2");
                        break;
                    }
                    case 8: {
                        this.m_sMessage1 = this.m_res.getString("sRunKaiseiAndEngine1");
                        this.m_sMessage2 = this.m_res.getString("sRunKaiseiAndEngine2");
                        break;
                    }
                    case 7: {
                        this.m_sMessage1 = this.m_res.getString("sRunKaisei1");
                        this.m_sMessage2 = this.m_res.getString("sRunKaisei2");
                        break;
                    }
                    case 9: {
                        this.m_sMessage1 = this.m_res.getString("sRunBackAndEngine1");
                        this.m_sMessage2 = this.m_res.getString("sRunBackAndEngine2");
                    }
                }
            }
        }
    }

    void drawAxis(Graphics graphics, int n, int n2, double d, Color color, int n3) {
        graphics.setColor(Color.white);
        graphics.fillArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 360 - (int)(d / (Math.PI * 2) * 360.0) + 180, 360);
        graphics.setColor(color);
        graphics.fillArc(n - n3, n2 - n3, n3 * 2, n3 * 2, 360 - (int)(d / (Math.PI * 2) * 360.0), 180);
    }

    public void viewGearsSpeed() {
        PlanetaryGear planetaryGear = this.m_thsController.getPlanetaryGear();
        int n = (int)planetaryGear.getRingGearSpeed();
        int n2 = (int)planetaryGear.getPlaCarrierSpeed();
        int n3 = (int)planetaryGear.getSunGearSpeed();
        n -= n % 50;
        n2 = n2 >= 1000 ? (n2 -= n2 % 50) : (n2 -= n2 % 10);
        n3 -= n3 % 10;
        this.lbRingGearSpeed.setText(String.valueOf(n) + " rpm");
        this.lbPlaCarrierSpeed.setText(String.valueOf(n2) + " rpm");
        this.lbSunGearSpeed.setText(String.valueOf(n3) + " rpm");
    }

    void sliRingGear_mouseMoved(MouseEvent mouseEvent) {
        if (!this.ckDriveMode.getState()) {
            this.m_sMessage1 = this.m_res.getString("sDescRingGear1");
            this.m_sMessage2 = this.m_res.getString("sDescRingGear2");
        }
    }

    void sliPlaCarrier_mouseMoved(MouseEvent mouseEvent) {
        if (!this.ckDriveMode.getState()) {
            this.m_sMessage1 = this.m_res.getString("sDescPlaCarrier1");
            this.m_sMessage2 = this.m_res.getString("sDescPlaCarrier2");
        }
    }

    void sliSunGear_mouseMoved(MouseEvent mouseEvent) {
        if (!this.ckDriveMode.getState()) {
            this.m_sMessage1 = this.m_res.getString("sDescSunGear1");
            this.m_sMessage2 = this.m_res.getString("sDescSunGear2");
        }
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        if (!this.ckDriveMode.getState()) {
            this.m_sMessage1 = this.m_res.getString("sDescGeneral1");
            this.m_sMessage2 = this.m_res.getString("sDescGeneral2");
        }
    }

    void ckDriveMode_itemStateChanged(ItemEvent itemEvent) {
        this.sliRingGear.setValue(0);
        this.sliPlaCarrier.setValue(0);
        this.sliSunGear.setValue(0);
        this.m_thsController.getPlanetaryGear().setRingGearSpeed(0.0);
        this.m_thsController.getPlanetaryGear().setPlaCarrierSpeed(0.0);
        this.lbRingGearSpeed.setText("0 rpm");
        this.lbPlaCarrierSpeed.setText("0 rpm");
        this.lbSunGearSpeed.setText("0 rpm");
        if (this.ckDriveMode.getState()) {
            this.sliAccel.setEnabled(true);
            this.sliBrake.setEnabled(true);
            this.cmbRange.setEnabled(true);
            this.cmbRange.select(0);
            this.m_thsController.setShiftPosition("P");
            this.sliRingGear.setEnabled(false);
            this.sliPlaCarrier.setEnabled(false);
            this.m_thsController.ignition();
        } else {
            this.sliAccel.setEnabled(false);
            this.sliBrake.setEnabled(false);
            this.cmbRange.setEnabled(false);
            this.cmbRange.select(0);
            this.sliAccel.setValue(0);
            this.sliBrake.setValue(0);
            this.m_thsController.setShiftPosition("P");
            this.sliRingGear.setEnabled(true);
            this.sliPlaCarrier.setEnabled(true);
            this.m_thsController.unIgnition();
        }
    }

    void cmbRange_itemStateChanged(ItemEvent itemEvent) {
        switch (this.cmbRange.getSelectedIndex()) {
            case 0: {
                this.m_thsController.setShiftPosition("P");
                break;
            }
            case 1: {
                this.m_thsController.setShiftPosition("R");
                break;
            }
            case 2: {
                this.m_thsController.setShiftPosition("N");
                break;
            }
            case 3: {
                this.m_thsController.setShiftPosition("D");
                break;
            }
            case 4: {
                this.m_thsController.setShiftPosition("B");
            }
        }
        if (this.m_thsController.getShiftPosition().equals("P")) {
            if (this.cmbRange.getSelectedIndex() != 0) {
                this.cmbRange.select(0);
            }
        } else if (this.m_thsController.getShiftPosition().equals("R")) {
            if (this.cmbRange.getSelectedIndex() != 1) {
                this.cmbRange.select(1);
            }
        } else if (this.m_thsController.getShiftPosition().equals("N")) {
            if (this.cmbRange.getSelectedIndex() != 2) {
                this.cmbRange.select(2);
            }
        } else if (this.m_thsController.getShiftPosition().equals("D")) {
            if (this.cmbRange.getSelectedIndex() != 3) {
                this.cmbRange.select(3);
            }
        } else if (this.m_thsController.getShiftPosition().equals("B") && this.cmbRange.getSelectedIndex() != 4) {
            this.cmbRange.select(4);
        }
        if (!this.m_thsController.getShiftPosition().equals("P")) {
            // empty if block
        }
    }

    void sliBrake_stateChanged(ChangeEvent changeEvent) {
        this.sliAccel.setValue(0);
    }

    void sliAccel_stateChanged(ChangeEvent changeEvent) {
        this.sliBrake.setValue(0);
    }

    void sliRingGear_stateChanged(ChangeEvent changeEvent) {
        PlanetaryGear planetaryGear = this.m_thsController.getPlanetaryGear();
        planetaryGear.setRingGearSpeed(this.sliRingGear.getValue());
        this.sliSunGear.setValue((int)planetaryGear.getSunGearSpeed());
        this.viewGearsSpeed();
    }

    void sliPlaCarrier_stateChanged(ChangeEvent changeEvent) {
        PlanetaryGear planetaryGear = this.m_thsController.getPlanetaryGear();
        planetaryGear.setPlaCarrierSpeed(this.sliPlaCarrier.getValue());
        this.sliSunGear.setValue((int)planetaryGear.getSunGearSpeed());
        this.viewGearsSpeed();
    }

    void ckDriveMode_mouseMoved(MouseEvent mouseEvent) {
        if (!this.ckDriveMode.getState()) {
            this.m_sMessage1 = this.m_res.getString("sDescDriveMode1");
            this.m_sMessage2 = this.m_res.getString("sDescDriveMode2");
        }
    }
}

