/*
 * Decompiled with CFR 0.152.
 */
package matsubara.graphics;

import java.awt.Color;
import java.awt.Graphics;
import matsubara.graphics.LineBase;

public class ProgressLine
extends LineBase {
    int m_nPosition = 0;
    boolean m_bReverse = false;
    int m_nMarkSize = 0;

    public ProgressLine(int n, int n2, int n3, int n4, Color color) {
        super(n, n2, n3, n4, color);
    }

    public ProgressLine(int n, int n2, int n3, int n4, Color color, int n5) {
        super(n, n2, n3, n4, color);
        this.setMarkSize(n5);
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        this.drawArrow(graphics);
        if (!this.isReverse()) {
            n2 = this.getStartX() + (this.getEndX() - this.getStartX()) * this.getPosition() / 100;
            n = this.getStartY() + (this.getEndY() - this.getStartY()) * this.getPosition() / 100;
        } else {
            n2 = this.getStartX() + (this.getEndX() - this.getStartX()) * (100 - this.getPosition()) / 100;
            n = this.getStartY() + (this.getEndY() - this.getStartY()) * (100 - this.getPosition()) / 100;
        }
        graphics.setColor(Color.white);
        graphics.fillArc(n2 - this.m_nMarkSize / 2, n - this.m_nMarkSize / 2, this.m_nMarkSize, this.m_nMarkSize, 0, 360);
    }

    public void setPosition(int n) {
        this.m_nPosition = n % 100;
    }

    int getPosition() {
        return this.m_nPosition;
    }

    public void movePosition(int n) {
        this.m_nPosition = (this.m_nPosition + n) % 100;
        if (this.m_nPosition < 0) {
            this.m_nPosition += 100;
        }
    }

    public void setReverse(boolean bl) {
        this.m_bReverse = bl;
    }

    public boolean isReverse() {
        return this.m_bReverse;
    }

    public int getMarkSize() {
        return this.m_nMarkSize;
    }

    public void setMarkSize(int n) {
        this.m_nMarkSize = n;
    }
}

